-- MySQL dump 10.10
--
-- Host: localhost    Database: vuoto
-- ------------------------------------------------------
-- Server version	5.0.19-standard

/*!40101 SET NAMES utf8 */;

--
-- Table structure for table `soraldo_access`
--

DROP TABLE IF EXISTS `soraldo_access`;
CREATE TABLE `soraldo_access` (
  `access_id` int(10) NOT NULL,
  `access_title` varchar(20) default NULL,
  PRIMARY KEY  (`access_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_access`
--


/*!40000 ALTER TABLE `soraldo_access` DISABLE KEYS */;
LOCK TABLES `soraldo_access` WRITE;
INSERT INTO `soraldo_access` VALUES (1,'Sospeso'),(16,'Operatore'),(32,'Amministratore'),(64,'Amministratore Unico'),(256,'Superuser');
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_access` ENABLE KEYS */;

--
-- Table structure for table `soraldo_authors`
--

DROP TABLE IF EXISTS `soraldo_authors`;
CREATE TABLE `soraldo_authors` (
  `aid` varchar(25) NOT NULL default '',
  `name` varchar(50) default NULL,
  `id_comune` int(11) NOT NULL default '0',
  `email` varchar(255) default NULL,
  `pwd` varchar(40) default NULL,
  `counter` int(11) NOT NULL default '0',
  `adminop` tinyint(2) NOT NULL default '0',
  `admincomune` tinyint(2) NOT NULL default '0',
  `adminsuper` tinyint(2) NOT NULL default '1',
  `admlanguage` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`aid`,`id_comune`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_authors`
--


/*!40000 ALTER TABLE `soraldo_authors` DISABLE KEYS */;
LOCK TABLES `soraldo_authors` WRITE;
INSERT INTO `soraldo_authors` VALUES ('suser','suser',0,'test@','098f6bcd4621d373cade4e832627b4f6',1,0,0,1,'it');
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_authors` ENABLE KEYS */;

--
-- Table structure for table `soraldo_config`
--

DROP TABLE IF EXISTS `soraldo_config`;
CREATE TABLE `soraldo_config` (
  `sitename` varchar(255) NOT NULL default '',
  `siteurl` varchar(255) NOT NULL default '',
  `site_logo` varchar(255) NOT NULL default '',
  `slogan` varchar(255) NOT NULL default '',
  `startdate` varchar(50) NOT NULL default '',
  `adminmail` varchar(255) NOT NULL default '',
  `tema` varchar(25) NOT NULL,
  `foot` text NOT NULL,
  `language` varchar(3) NOT NULL,
  `blocco` enum('0','1') NOT NULL,
  `testata` blob,
  `nome_testata` varchar(50) NOT NULL,
  `fileout` varchar(255) NOT NULL,
  `copyright` text NOT NULL,
  `Versione` int(3) NOT NULL,
  `patch` int(3) NOT NULL,
  `siteistat` int(11) NOT NULL,
  `multicomune` enum('0','1') NOT NULL,
  `flash` enum('0','1') NOT NULL,
  `displayerrors` enum('0','1') NOT NULL,
  `gkey` varchar(100) NOT NULL,
  `googlemaps` enum('0','1') NOT NULL,
  `editor` enum('0','1') NOT NULL default '1',
  `tema_on` enum('0','1') NOT NULL default '1',
  `ed_user` varchar(25) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_config`
--


/*!40000 ALTER TABLE `soraldo_config` DISABLE KEYS */;
LOCK TABLES `soraldo_config` WRITE;
INSERT INTO `soraldo_config` VALUES ('','http://www.fonte-nuova.it','','Sito istituzionale','Maggio 2009','admin@localhost','facebook','<b>Comune di Menfi</b><br>\r\nvia  - 84023 Menfi (Ag)\r\nTel:  Fax: \r\n<hr>','it','1','','','','Gpl v3',2,0,84023,'1','1','0','','0','1','1','Admin');
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_config` ENABLE KEYS */;

--
-- Table structure for table `soraldo_doc_cons`
--

DROP TABLE IF EXISTS `soraldo_ele_controllosez`;
create table soraldo_ele_controllosez (
id_sez int(11),
 id_cons int(11),
 stato_aff int(1),
 stato_val int(1),
 stato_gru int(1),
 stato_lis int(1),
 stato_can int(1),
 status int(1) DEFAULT '0',
 primary key (id_sez)
 ) ENGINE=MyISAM DEFAULT CHARSET=latin1;



DROP TABLE IF EXISTS `soraldo_doc_cons`;
CREATE TABLE `soraldo_doc_cons` (
  `id_cons` int(11) NOT NULL,
  `id_doc` int(11) NOT NULL,
  `tabella` varchar(25) NOT NULL,
  KEY `id_cons` (`id_cons`,`id_doc`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_doc_cons`
--


/*!40000 ALTER TABLE `soraldo_doc_cons` DISABLE KEYS */;
LOCK TABLES `soraldo_doc_cons` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_doc_cons` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_candidati`
--

DROP TABLE IF EXISTS `soraldo_ele_candidati`;
CREATE TABLE `soraldo_ele_candidati` (
  `id_cand` int(11) NOT NULL auto_increment,
  `id_cons` int(11) NOT NULL default '0',
  `id_lista` int(11) NOT NULL default '0',
  `cognome` varchar(50) default NULL,
  `nome` varchar(50) default NULL,
  `note` tinytext NOT NULL,
  `simbolo` varchar(30) NOT NULL default '',
  `num_cand` int(7) NOT NULL default '0',
  UNIQUE KEY `id_cand` (`id_cand`),
  KEY `id_cons` (`id_cons`),
  KEY `id_lista` (`id_lista`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_candidati`
--


/*!40000 ALTER TABLE `soraldo_ele_candidati` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_candidati` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_candidati` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_circoscrizione`
--

DROP TABLE IF EXISTS `soraldo_ele_circoscrizione`;
CREATE TABLE `soraldo_ele_circoscrizione` (
  `id_cons` int(11) NOT NULL default '0',
  `id_circ` int(11) NOT NULL auto_increment,
  `num_circ` int(7) NOT NULL default '0',
  `descrizione` text,
  UNIQUE KEY `id_circ` (`id_circ`),
  UNIQUE KEY `id_cons` (`id_cons`,`num_circ`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_circoscrizione`
--


/*!40000 ALTER TABLE `soraldo_ele_circoscrizione` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_circoscrizione` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_circoscrizione` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_collegi`
--

DROP TABLE IF EXISTS `soraldo_ele_collegi`;
CREATE TABLE `soraldo_ele_collegi` (
  `id_collegio` int(11) NOT NULL auto_increment,
  `id_cons_gen` int(11) NOT NULL default '0',
  `descrizione` text,
  PRIMARY KEY  (`id_collegio`),
  KEY `id_cons_gen` (`id_cons_gen`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_collegi`
--


/*!40000 ALTER TABLE `soraldo_ele_collegi` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_collegi` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_collegi` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_come`
--

DROP TABLE IF EXISTS `soraldo_ele_come`;
CREATE TABLE `soraldo_ele_come` (
  `id_cons` int(11) NOT NULL default '0',
  `mid` int(7) NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `preamble` text NOT NULL,
  `content` text NOT NULL,
  `editimage` varchar(100) NOT NULL default '',
  UNIQUE KEY `mid` (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_come`
--


/*!40000 ALTER TABLE `soraldo_ele_come` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_come` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_come` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_comu_collegi`
--

DROP TABLE IF EXISTS `soraldo_ele_comu_collegi`;
CREATE TABLE `soraldo_ele_comu_collegi` (
  `id_collegio` int(11) NOT NULL default '0',
  `id_cons` int(11) NOT NULL default '0',
  `id_comune` int(11) NOT NULL default '0',
  `id_cons_gen` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_cons_gen`,`id_comune`),
  KEY `id_cons` (`id_cons`),
  KEY `id_collegio` (`id_collegio`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_comu_collegi`
--


/*!40000 ALTER TABLE `soraldo_ele_comu_collegi` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_comu_collegi` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_comu_collegi` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_comuni`
--

DROP TABLE IF EXISTS `soraldo_ele_comuni`;
CREATE TABLE `soraldo_ele_comuni` (
  `id_comune` int(11) NOT NULL default '0',
  `descrizione` varchar(50) default NULL,
  `indirizzo` varchar(50) default NULL,
  `centralino` varchar(15) default NULL,
  `fax` varchar(15) default NULL,
  `email` varchar(50) default NULL,
  `fascia` tinyint(4) NOT NULL default '0',
  `capoluogo` enum('0','1') NOT NULL default '0',
  `simbolo` text,
  `stemma` blob,
  `id_cons` int(11) default '0',
  `cap` text,
  PRIMARY KEY  (`id_comune`),
  KEY `access_id` (`descrizione`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_comuni`
--


/*!40000 ALTER TABLE `soraldo_ele_comuni` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_comuni` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_comuni` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_conf`
--

DROP TABLE IF EXISTS `soraldo_ele_conf`;
CREATE TABLE `soraldo_ele_conf` (
  `id_conf` int(11) NOT NULL AUTO_INCREMENT,
  `descrizione` varchar(50) NOT NULL,
  `limite` int(2) NOT NULL,
  `consin` enum('0','1') NOT NULL DEFAULT '1',
  `infpremio` int(3) NOT NULL,
  `supsbarramento` int(3) NOT NULL,
  `suppremio` int(3) NOT NULL,
  `listinfsbar` int(3) NOT NULL DEFAULT '1',
  `listinfconta` enum('0','1') NOT NULL DEFAULT '1',
  `listsupconta` enum('0','1') NOT NULL DEFAULT '1',
  `supminpremio` int(3) NOT NULL,
  `infminpremio` int(3) NOT NULL,
  `infdisgiunto` enum('0','1') NOT NULL DEFAULT '0',
  `supdisgiunto` enum('0','1') NOT NULL DEFAULT '0',
  `votolista` enum('0','1') NOT NULL DEFAULT '0',
  `inffisso` enum('0','1') NOT NULL DEFAULT '0',
  `supfisso` enum('0','1') NOT NULL DEFAULT '0',
  `fascia_capoluogo` int(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_conf`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=7 ;


--
-- Dumping data for table `soraldo_ele_conf`
--


/*!40000 ALTER TABLE `soraldo_ele_conf` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_conf` WRITE;
INSERT INTO `soraldo_ele_conf` (`id_conf`, `descrizione`, `limite`, `consin`, `infpremio`, `supsbarramento`, `suppremio`, `listinfsbar`, `listinfconta`, `listsupconta`, `supminpremio`, `infminpremio`, `infdisgiunto`, `supdisgiunto`, `votolista`, `inffisso`, `supfisso`, `fascia_capoluogo`) VALUES
(1, 'Legge Italiana 267/2000', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 6),
(2, 'Regione Sicilia precedente al 2008', 2, '0', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 6),
(3, 'Regione Sicilia Legge n. 22 del 16/12/2008', 2, '0', 67, 5, 60, 3, '1', '0', 40, 40, '0', '0', '0', '0', '0', 7),
(4, 'Regione Sicilia Legge n.6/2011', 5, '1', 67, 5, 60, 5, '1', '1', 40, 40, '1', '1', '0', '0', '0', 7),
(5, 'Legge Italiana 267/2000 con riduzione 2011', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 7),
(6, 'Legge Italiana 267/2000 con riduzione 2012', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 7),
(7, 'Legge Italiana 267/2000 con modifiche 2014', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 6);
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_conf` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_cons_comune`
--

DROP TABLE IF EXISTS `soraldo_ele_cons_comune`;
CREATE TABLE `soraldo_ele_cons_comune` (
  `id_cons` int(11) NOT NULL auto_increment,
  `chiusa` set('0','1','2') NOT NULL default '0',
  `id_comune` int(11) NOT NULL default '0',
  `id_cons_gen` int(11) NOT NULL default '0',
  `id_conf` int(11) NOT NULL default '0',
  `preferita` enum('0','1') NOT NULL default '0',
  `preferenze` TINYINT( 1 ) NOT NULL DEFAULT '1',
  `id_fascia` INT( 2 ) NOT NULL DEFAULT '1',
  `vismf` ENUM( '0', '1' ) NOT NULL DEFAULT '0',
  `solo_gruppo` enum('0', '1') NOT NULL default '0',
  `disgiunto` enum('0', '1') NOT NULL default '0',
  PRIMARY KEY  (`id_cons`),
  UNIQUE KEY `comune` (`id_comune`,`id_cons_gen`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_cons_comune`
--


/*!40000 ALTER TABLE `soraldo_ele_cons_comune` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_cons_comune` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_cons_comune` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_consultazione`
--

DROP TABLE IF EXISTS `soraldo_ele_consultazione`;
CREATE TABLE `soraldo_ele_consultazione` (
  `id_cons_gen` int(11) NOT NULL auto_increment,
  `descrizione` text,
  `data_inizio` date default NULL,
  `data_fine` date default NULL,
  `tipo_cons` int(7) NOT NULL default '0',
  PRIMARY KEY  (`id_cons_gen`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_consultazione`
--


/*!40000 ALTER TABLE `soraldo_ele_consultazione` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_consultazione` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_consultazione` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_documenti`
--

DROP TABLE IF EXISTS `soraldo_ele_documenti`;
CREATE TABLE `soraldo_ele_documenti` (
  `id_doc` int(11) NOT NULL auto_increment,
  `descrizione` varchar(50) NOT NULL,
  `nomedoc` varchar(25) NOT NULL,
  `filedoc` blob NOT NULL,
  PRIMARY KEY  (`id_doc`),
  KEY `descrizione` (`descrizione`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_documenti`
--


/*!40000 ALTER TABLE `soraldo_ele_documenti` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_documenti` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_documenti` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_fasce`
--

DROP TABLE IF EXISTS `soraldo_ele_fasce`;
CREATE TABLE `soraldo_ele_fasce` (
  `id_fascia` int(2) NOT NULL,
  `abitanti` int(11) NOT NULL,
  `seggi` int(4) NOT NULL,
  `id_conf` int(11) DEFAULT '1',
  KEY `id_fascia` (`id_fascia`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_fasce`
--

LOCK TABLES `soraldo_ele_fasce` WRITE;
/*!40000 ALTER TABLE `soraldo_ele_fasce` DISABLE KEYS */;
INSERT INTO `soraldo_ele_fasce` VALUES 
(1, 3000, 12, 1),
(2, 10000, 16, 1),
(3, 15000, 20, 1),
(4, 30000, 20, 1),
(5, 100000, 30, 1),
(6, 250000, 40, 1),
(7, 500000, 46, 1),
(8, 1000000, 50, 1),
(9, 100000000, 60, 1),
(1, 3000, 12, 2),
(2, 10000, 16, 2),
(3, 15000, 20, 2),
(4, 30000, 20, 2),
(5, 100000, 30, 2),
(6, 250000, 40, 2),
(7, 500000, 46, 2),
(8, 1000000, 50, 2),
(9, 100000000, 60, 2),
(1, 3000, 9, 3),
(2, 5000, 9, 3),
(4, 15000, 16, 3),
(3, 10000, 12, 3),
(5, 30000, 16, 3),
(6, 100000, 24, 3),
(7, 250000, 32, 3),
(8, 500000, 36, 3),
(9, 1000000, 40, 3),
(10, 100000000, 48, 3),
(1, 3000, 6, 4),
(2, 5000, 7, 4),
(3, 10000, 12, 4),
(4, 15000, 16, 4),
(5, 30000, 16, 4),
(6, 100000, 24, 4),
(7, 250000, 32, 4),
(8, 500000, 36, 4),
(9, 1000000, 40, 4),
(10, 100000000, 48, 4),
(1, 3000, 9, 5),
(2, 5000, 9, 5),
(3, 10000, 12, 5),
(4, 15000, 16, 5),
(5, 30000, 16, 5),
(6, 100000, 24, 5),
(7, 250000, 32, 5),
(8, 500000, 36, 5),
(9, 1000000, 40, 5),
(10, 100000000, 48, 5),
(1, 3000, 6, 6),
(2, 5000, 7, 6),
(3, 10000, 10, 6),
(4, 15000, 16, 6),
(5, 30000, 16, 6),
(6, 100000, 24, 6),
(7, 250000, 32, 6),
(8, 500000, 36, 6),
(9, 1000000, 40, 6),
(10, 100000000, 48, 6),
(1, 3000, 10, 7),
(2, 10000, 12, 7),
(3, 15000, 16, 7),
(4, 30000, 16, 7),
(5, 100000, 24, 7),
(6, 250000, 32, 7),
(7, 500000, 36, 7),
(8, 1000000, 40, 7),
(9, 100000000, 48, 7);
/*!40000 ALTER TABLE `soraldo_ele_fasce` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `soraldo_ele_gruppo`
--

DROP TABLE IF EXISTS `soraldo_ele_gruppo`;
CREATE TABLE `soraldo_ele_gruppo` (
  `id_cons` int(11) NOT NULL default '0',
  `id_gruppo` int(11) NOT NULL auto_increment,
  `num_gruppo` int(7) NOT NULL default '0',
  `descrizione` text,
  `simbolo` text,
  `stemma` blob,
  `id_circ` int(11) NOT NULL default '0',
  `prognome` text,
  `programma` mediumblob,
  UNIQUE KEY `id_gruppo` (`id_gruppo`),
  UNIQUE KEY `id_cons` (`id_cons`,`num_gruppo`,`id_circ`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_gruppo`
--


/*!40000 ALTER TABLE `soraldo_ele_gruppo` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_gruppo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_gruppo` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_link`
--

DROP TABLE IF EXISTS `soraldo_ele_link`;
CREATE TABLE `soraldo_ele_link` (
  `id_cons` int(11) NOT NULL default '0',
  `mid` int(7) NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `preamble` text NOT NULL,
  `content` text NOT NULL,
  `editimage` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_link`
--


/*!40000 ALTER TABLE `soraldo_ele_link` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_link` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_link` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_lista`
--

DROP TABLE IF EXISTS `soraldo_ele_lista`;
CREATE TABLE `soraldo_ele_lista` (
  `id_cons` int(11) NOT NULL default '0',
  `id_lista` int(11) NOT NULL auto_increment,
  `num_lista` int(7) NOT NULL default '0',
  `id_gruppo` int(11) NOT NULL default '0',
  `id_circ` int(11) NOT NULL default '0',
  `descrizione` text,
  `simbolo` text,
  `stemma` blob,
  PRIMARY KEY  (`id_cons`,`num_lista`,`id_circ`),
  UNIQUE KEY `id_lista` (`id_lista`),
  KEY `id_gruppo` (`id_gruppo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_lista`
--


/*!40000 ALTER TABLE `soraldo_ele_lista` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_lista` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_lista` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_log`
--

DROP TABLE IF EXISTS `soraldo_ele_log`;
CREATE TABLE `soraldo_ele_log` (
  `id_cons` int(11) default NULL,
  `id_sez` int(11) default NULL,
  `utente` varchar(20) default NULL,
  `data` date default NULL,
  `ora` time default NULL,
  `log_da` text,
  `log_a` text,
  `tabella` varchar(30) default NULL,
  KEY `id_cons` (`id_cons`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_log`
--


/*!40000 ALTER TABLE `soraldo_ele_log` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_log` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_log` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_modelli`
--

DROP TABLE IF EXISTS `soraldo_ele_modelli`;
CREATE TABLE `soraldo_ele_modelli` (
  `id_cons` int(11) NOT NULL default '0',
  `categoria` varchar(20) NOT NULL default '',
  `modello` blob NOT NULL,
  KEY `access_id` (`id_cons`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_modelli`
--


/*!40000 ALTER TABLE `soraldo_ele_modelli` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_modelli` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_modelli` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_numeri`
--

DROP TABLE IF EXISTS `soraldo_ele_numeri`;
CREATE TABLE `soraldo_ele_numeri` (
  `id_cons` int(11) NOT NULL default '0',
  `mid` int(7) NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `preamble` text NOT NULL,
  `content` text NOT NULL,
  `editimage` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`mid`),
  KEY `id_cons` (`id_cons`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_numeri`
--


/*!40000 ALTER TABLE `soraldo_ele_numeri` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_numeri` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_numeri` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_operatori`
--

DROP TABLE IF EXISTS `soraldo_ele_operatori`;
CREATE TABLE `soraldo_ele_operatori` (
  `id_cons` int(11) NOT NULL default '0',
  `id_sede` int(11) NOT NULL default '0',
  `id_comune` int(11) NOT NULL default '0',
  `permessi` int(3) default NULL,
  `aid` varchar(25) NOT NULL default '',
  UNIQUE KEY `id_cons_aid` (`id_cons`,`aid`,`id_comune`),
  KEY `id_circ` (`id_comune`),
  KEY `id_sede` (`id_sede`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_operatori`
--


/*!40000 ALTER TABLE `soraldo_ele_operatori` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_operatori` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_operatori` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_province`
--

DROP TABLE IF EXISTS `soraldo_ele_province`;
CREATE TABLE `soraldo_ele_province` (
  `id` tinyint(11) NOT NULL,
  `descrizione` varchar(30) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_province`
--


/*!40000 ALTER TABLE `soraldo_ele_province` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_province` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_province` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_regioni`
--

DROP TABLE IF EXISTS `soraldo_ele_regioni`;
CREATE TABLE `soraldo_ele_regioni` (
  `id` int(11) NOT NULL,
  `descrizione` varchar(25) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `descrizione` (`descrizione`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_regioni`
--


/*!40000 ALTER TABLE `soraldo_ele_regioni` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_regioni` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_regioni` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_rilaff`
--

DROP TABLE IF EXISTS `soraldo_ele_rilaff`;
CREATE TABLE `soraldo_ele_rilaff` (
  `id_cons_gen` int(11) NOT NULL default '0',
  `orario` time NOT NULL default '00:00:00',
  `data` date NOT NULL default '0000-00-00',
  KEY `id_cons_gen` (`id_cons_gen`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_rilaff`
--


/*!40000 ALTER TABLE `soraldo_ele_rilaff` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_rilaff` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_rilaff` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_sede`
--

DROP TABLE IF EXISTS `soraldo_ele_sede`;
CREATE TABLE `soraldo_ele_sede` (
  `id_cons` int(11) NOT NULL default '0',
  `id_sede` int(11) NOT NULL auto_increment,
  `id_circ` int(11) NOT NULL default '0',
  `indirizzo` varchar(60) default NULL,
  `telefono1` varchar(12) default NULL,
  `telefono2` varchar(12) default NULL,
  `fax` varchar(12) default NULL,
  `responsabile` varchar(60) default NULL,
  `mappa` mediumblob NOT NULL,
  `filemappa` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id_sede`),
  KEY `id_cons` (`id_cons`),
  KEY `id_circ` (`id_circ`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_sede`
--


/*!40000 ALTER TABLE `soraldo_ele_sede` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_sede` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_sede` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_servizi`
--

DROP TABLE IF EXISTS `soraldo_ele_servizi`;
CREATE TABLE `soraldo_ele_servizi` (
  `id_cons` int(11) NOT NULL default '0',
  `mid` int(7) NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `preamble` text NOT NULL,
  `content` text NOT NULL,
  `editimage` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`mid`),
  KEY `id_cons` (`id_cons`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_servizi`
--


/*!40000 ALTER TABLE `soraldo_ele_servizi` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_servizi` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_servizi` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_sezioni`
--

DROP TABLE IF EXISTS `soraldo_ele_sezioni`;
CREATE TABLE `soraldo_ele_sezioni` (
  `id_cons` int(11) NOT NULL default '0',
  `id_sez` int(11) NOT NULL auto_increment,
  `id_sede` int(11) NOT NULL default '0',
  `num_sez` int(7) NOT NULL default '0',
  `maschi` int(4) default NULL,
  `femmine` int(4) default NULL,
  `validi` int(7) NOT NULL default '0',
  `nulli` int(7) NOT NULL default '0',
  `bianchi` int(7) NOT NULL default '0',
  `contestati` int(7) NOT NULL default '0',
  `solo_gruppo` int(7) NOT NULL default '0',
  `autorizzati_m` int(4) NOT NULL default '0',
  `autorizzati_f` int(4) NOT NULL default '0',
  `voti_nulli` int(7) NOT NULL default '0',
  `validi_lista` int(7) NOT NULL default '0',
  `contestati_lista` int(7) NOT NULL default '0',
  `voti_nulli_lista` int(7) NOT NULL default '0',
  `solo_lista` int(7) NOT NULL DEFAULT '0',
  UNIQUE KEY `id_sezi` (`id_sez`),
  KEY `id_cons` (`id_cons`),
  KEY `id_sede` (`id_sede`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_sezioni`
--


/*!40000 ALTER TABLE `soraldo_ele_sezioni` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_sezioni` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_sezioni` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_temi`
--

DROP TABLE IF EXISTS `soraldo_ele_temi`;
CREATE TABLE IF NOT EXISTS `soraldo_ele_temi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tema` varchar(20) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

--
-- Dumping data for table `soraldo_ele_temi`
--



--
-- Table structure for table `soraldo_ele_tipo`
--

DROP TABLE IF EXISTS `soraldo_ele_tipo`;
CREATE TABLE `soraldo_ele_tipo` (
  `tipo_cons` int(11) NOT NULL default '0',
  `descrizione` varchar(30) default NULL,
  `lingua` varchar(2) NOT NULL default '0',
  `genere` tinyint(4) NOT NULL default '0',
  `voto_g` enum('0','1') NOT NULL default '0',
  `voto_l` enum('0','1') NOT NULL default '0',
  `voto_c` enum('0','1') NOT NULL default '0',
  `circo` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`tipo_cons`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_tipo`
--


/*!40000 ALTER TABLE `soraldo_ele_tipo` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_tipo` WRITE;
INSERT INTO `soraldo_ele_tipo` VALUES 
(1, 'PROVINCIALI', 'it', 3, '0', '0', '0', '0'),
(2, 'REFERENDUM', 'it', 0, '0', '0', '0', '0'),
(3, 'COMUNALI', 'it', 5, '0', '0', '0', '0'),
(4, 'CIRCOSCRIZIONALI', 'it', 5, '0', '0', '0', '1'),
(5, 'BALLOTTAGGIO COMUNALI', 'it', 1, '0', '0', '0', '0'),
(6, 'CAMERA', 'it', 2, '0', '0', '0', '0'),
(7, 'SENATO', 'it', 2, '0', '0', '0', '0'),
(8, 'EUROPEE', 'it', 4, '1', '0', '0', '0'),
(9, 'REGIONALI', 'it', 5, '0', '0', '0', '0'),
(10, 'SENATO CON GRUPPI', 'it', 5, '1', '0', '1', '0'),
(11, 'CAMERA CON GRUPPI', 'it', 5, '1', '0', '1', '0'),
(12, 'PROVINCIALI CON COLLEGI', 'it', 3, '0', '0', '0', '1'),
(13, 'BALLOTTAGGIO PROVINCIALI', 'it', 1, '0', '0', '0', '0'),
(14, 'EUROPEE CON COLLEGI', 'it', 4, '0', '0', '0', '1'),
(15, 'CAMERA CON GRUPPI E COLLEGI', 'it', 5, '1', '0', '1', '1'),
(16, 'SENATO CON GRUPPI E COLLEGI', 'it', 5, '1', '0', '1', '1'),
(17, 'REGIONALI CON COLLEGI', 'it', 5, '0', '0', '0', '1'),
(18, 'CAMERA - Rosatellum 2.0', 'it', 5, '0', '0', '1', '0'),
(19, 'SENATO - Rosatellum 2.0', 'it', 5, '0', '0', '1', '0');
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_tipo` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_voti_candidati`
--

DROP TABLE IF EXISTS `soraldo_ele_voti_candidati`;
CREATE TABLE `soraldo_ele_voti_candidati` (
  `id_cons` int(11) NOT NULL default '0',
  `id_cand` int(11) NOT NULL default '0',
  `id_sez` int(11) NOT NULL default '0',
  `voti` int(7) NOT NULL default '0',
  KEY `id_sez` (`id_sez`),
  KEY `id_cand` (`id_cand`),
  KEY `id_cons` (`id_cons`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_voti_candidati`
--


/*!40000 ALTER TABLE `soraldo_ele_voti_candidati` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_voti_candidati` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_voti_candidati` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_voti_gruppo`
--

DROP TABLE IF EXISTS `soraldo_ele_voti_gruppo`;
CREATE TABLE `soraldo_ele_voti_gruppo` (
  `id_cons` int(11) NOT NULL default '0',
  `id_gruppo` int(11) NOT NULL default '0',
  `id_sez` int(11) NOT NULL default '0',
  `voti` int(7) NOT NULL default '0',
  `solo_gruppo` INT( 7 ) NOT NULL DEFAULT '0',
  KEY `id_cons` (`id_cons`),
  KEY `id_gruppo` (`id_gruppo`),
  KEY `id_sez` (`id_sez`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_voti_gruppo`
--


/*!40000 ALTER TABLE `soraldo_ele_voti_gruppo` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_voti_gruppo` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_voti_gruppo` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_voti_lista`
--

DROP TABLE IF EXISTS `soraldo_ele_voti_lista`;
CREATE TABLE `soraldo_ele_voti_lista` (
  `id_cons` int(11) NOT NULL default '0',
  `id_lista` int(11) NOT NULL default '0',
  `id_sez` int(11) NOT NULL default '0',
  `voti` int(7) NOT NULL default '0',
  `nulli_lista` INT( 7 ) NOT NULL DEFAULT '0',
  `solo_lista` INT( 7 ) NOT NULL DEFAULT '0',
  KEY `cons` (`id_cons`),
  KEY `id_lista` (`id_lista`),
  KEY `id_sez` (`id_sez`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_voti_lista`
--


/*!40000 ALTER TABLE `soraldo_ele_voti_lista` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_voti_lista` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_voti_lista` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_voti_parziale`
--

DROP TABLE IF EXISTS `soraldo_ele_voti_parziale`;
CREATE TABLE `soraldo_ele_voti_parziale` (
  `id_cons` int(11) NOT NULL default '0',
  `id_sez` int(11) NOT NULL default '0',
  `id_parz` int(11) NOT NULL auto_increment,
  `orario` time NOT NULL default '00:00:00',
  `data` date NOT NULL default '0000-00-00',
  `voti_uomini` int(7) NOT NULL default '0',
  `voti_donne` int(7) NOT NULL default '0',
  `voti_complessivi` int(7) NOT NULL default '0',
  `id_gruppo` int(11) NOT NULL default '0',
  PRIMARY KEY  (`id_parz`),
  KEY `id_cons` (`id_cons`),
  KEY `id_sez` (`id_sez`),
  KEY `id_gruppo` (`id_gruppo`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_voti_parziale`
--


/*!40000 ALTER TABLE `soraldo_ele_voti_parziale` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_voti_parziale` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_voti_parziale` ENABLE KEYS */;

--
-- Table structure for table `soraldo_ele_voti_ref`
--

DROP TABLE IF EXISTS `soraldo_ele_voti_ref`;
CREATE TABLE `soraldo_ele_voti_ref` (
  `id_cons` int(11) NOT NULL default '0',
  `id_gruppo` int(11) NOT NULL default '0',
  `id_sez` int(11) NOT NULL default '0',
  `si` int(7) default '0',
  `no` int(7) default '0',
  `validi` int(7) default '0',
  `nulli` int(7) default '0',
  `bianchi` int(7) default '0',
  `contestati` int(7) default '0',
  KEY `id_cons` (`id_cons`),
  KEY `id_gruppo` (`id_gruppo`),
  KEY `id_sez` (`id_sez`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Dumping data for table `soraldo_ele_voti_ref`
--


/*!40000 ALTER TABLE `soraldo_ele_voti_ref` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_voti_ref` WRITE;
UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_voti_ref` ENABLE KEYS */;

--
-- Struttura della tabella `soraldo_ele_widget`
--

DROP TABLE IF EXISTS `soraldo_ele_widget`;
CREATE TABLE IF NOT EXISTS `soraldo_ele_widget` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `nome_file` varchar(255) NOT NULL DEFAULT '',
  `titolo` varchar(255) NOT NULL DEFAULT '',
  `pos_or` int(1) NOT NULL DEFAULT '1',
  `pos_ver` int(3) NOT NULL DEFAULT '0',
  `attivo` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=13 ;

--
-- Dump dei dati per la tabella `soraldo_ele_widget`
--


/*!40000 ALTER TABLE `soraldo_ele_widget` DISABLE KEYS */;
LOCK TABLES `soraldo_ele_widget` WRITE;

INSERT INTO `soraldo_ele_widget` (`id`, `nome_file`, `titolo`, `pos_or`, `pos_ver`, `attivo`) VALUES
(1, '00_affluenze.php', '00_affluenze.php', 1, 0, 0),
(2, '01_votanti.php', '01_votanti.php', 1, 0, 0),
(3, '02_risultati.php', '02_risultati.php', 1, 0, 0),
(4, '04_sezioni.php', '04_sezioni.php', 1, 0, 0),
(5, 'bar_affluenze.php', 'bar_affluenze.php', 1, 0, 0),
(6, 'bloccocand.php', 'bloccocand.php', 1, 0, 0),
(7, 'bloccogen.php', 'bloccogen.php', 1, 0, 0),
(8, 'bloccolink.php', 'bloccolink.php', 1, 0, 0),
(9, 'bloccoref.php', 'bloccoref.php', 1, 0, 0),
(10, 'gom_affluenze.php', 'gom_affluenze.php', 1, 0, 0),
(11, 'off_Votanti.php', 'off_Votanti.php', 1, 0, 0),
(12, 'pie_affluenze.php', 'pie_affluenze.php', 1, 0, 0);

UNLOCK TABLES;
/*!40000 ALTER TABLE `soraldo_ele_widget` ENABLE KEYS */;


