SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

/* CREATE DATABASE IF NOT EXISTS `eleonline` DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci;
USE `eleonline`;
*/
CREATE TABLE `soraldo_access` (
  `access_id` int(10) NOT NULL,
  `access_title` varchar(20) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_access` (`access_id`, `access_title`) VALUES
(1, 'Sospeso'),
(16, 'Operatore'),
(32, 'Amministratore'),
(64, 'Amministratore Unico'),
(256, 'Superuser');

CREATE TABLE `soraldo_authors` (
  `aid` varchar(25) NOT NULL DEFAULT '',
  `name` varchar(50) DEFAULT NULL,
  `id_comune` int(11) NOT NULL DEFAULT 0,
  `email` varchar(255) DEFAULT NULL,
  `pwd` varchar(40) DEFAULT NULL,
  `counter` int(11) NOT NULL DEFAULT 0,
  `adminop` tinyint(2) NOT NULL DEFAULT 0,
  `admincomune` tinyint(2) NOT NULL DEFAULT 0,
  `adminsuper` tinyint(2) NOT NULL DEFAULT 0,
  `admlanguage` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_authors` (`aid`, `name`, `id_comune`, `email`, `pwd`, `counter`, `adminop`, `admincomune`, `adminsuper`, `admlanguage`) VALUES
('suser', 'suser', 0, 'test@eleonline.it', '098f6bcd4621d373cade4e832627b4f6', 1, 0, 0, 1, 'it');

CREATE TABLE `soraldo_config` (
  `sitename` varchar(255) NOT NULL DEFAULT '',
  `siteurl` varchar(255) NOT NULL DEFAULT '',
  `site_logo` varchar(255) NOT NULL DEFAULT '',
  `slogan` varchar(255) NOT NULL DEFAULT '',
  `startdate` varchar(50) NOT NULL DEFAULT '',
  `adminmail` varchar(255) NOT NULL DEFAULT '',
  `tema` varchar(25) NOT NULL DEFAULT '',
  `foot` mediumtext NOT NULL,
  `language` char(3) NOT NULL DEFAULT '',
  `blocco` enum('0','1') NOT NULL DEFAULT '0',
  `testata` blob DEFAULT NULL,
  `nome_testata` varchar(50) NOT NULL DEFAULT '',
  `fileout` varchar(255) NOT NULL DEFAULT '',
  `copyright` mediumtext NOT NULL,
  `versione` int(3) DEFAULT NULL,
  `patch` int(3) NOT NULL DEFAULT 0,
  `siteistat` int(11) NOT NULL DEFAULT 0,
  `multicomune` enum('0','1') NOT NULL DEFAULT '0',
  `flash` enum('0','1') NOT NULL DEFAULT '0',
  `displayerrors` enum('0','1') NOT NULL DEFAULT '0',
  `gkey` varchar(100) NOT NULL DEFAULT '',
  `googlemaps` enum('0','1') NOT NULL DEFAULT '0',
  `editor` enum('0','1') NOT NULL DEFAULT '1',
  `tema_on` enum('0','1') NOT NULL DEFAULT '1',
  `ed_user` varchar(25) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_config` (`sitename`, `siteurl`, `site_logo`, `slogan`, `startdate`, `adminmail`, `tema`, `foot`, `language`, `blocco`, `testata`, `nome_testata`, `fileout`, `copyright`, `versione`, `patch`, `siteistat`, `multicomune`, `flash`, `displayerrors`, `gkey`, `googlemaps`, `editor`, `tema_on`, `ed_user`) VALUES
('Elezioni On Line', 'http://localhost/ele3/trunk/client', '', 'Sito istituzionale', 'March 2023', 'test@eleonline.it', 'default', '', 'it', '1', '', '', '', 'Gpl v3', 3, 0, 58047, '0', '0', '0', '', '0', '1', '1', 'Admin');

CREATE TABLE `soraldo_doc_cons` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_doc` int(11) NOT NULL DEFAULT 0,
  `tabella` varchar(25) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_candidati` (
  `id_cand` int(11) NOT NULL,
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_lista` int(11) NOT NULL DEFAULT 0,
  `num_lista` int(2) UNSIGNED NOT NULL,
  `cognome` varchar(50) DEFAULT NULL,
  `nome` varchar(50) DEFAULT NULL,
  `note` text NOT NULL,
  `simbolo` varchar(30) NOT NULL DEFAULT '',
  `num_cand` int(7) NOT NULL DEFAULT 0,
  `cv` varchar(255) NOT NULL,
  `cg` varchar(255) NOT NULL,
  `eletto` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_circoscrizione` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_circ` int(11) NOT NULL,
  `num_circ` int(7) NOT NULL DEFAULT 0,
  `descrizione` mediumtext DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_collegi` (
  `id_collegio` int(11) NOT NULL,
  `id_cons_gen` int(11) NOT NULL DEFAULT 0,
  `descrizione` mediumtext DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_come` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `mid` int(7) NOT NULL,
  `title` varchar(150) NOT NULL DEFAULT ' ',
  `preamble` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `editimage` varchar(100) NOT NULL DEFAULT ' '
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_comuni` (
  `id_comune` int(11) NOT NULL DEFAULT 0,
  `descrizione` varchar(50) DEFAULT NULL,
  `indirizzo` varchar(50) DEFAULT NULL,
  `centralino` varchar(15) DEFAULT NULL,
  `fax` varchar(15) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `fascia` tinyint(4) NOT NULL DEFAULT 0,
  `capoluogo` enum('0','1') NOT NULL DEFAULT '0',
  `simbolo` mediumtext DEFAULT NULL,
  `stemma` blob DEFAULT NULL,
  `id_cons` int(11) DEFAULT 0,
  `cap` mediumtext DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_ele_comuni` (`id_comune`, `descrizione`, `indirizzo`, `centralino`, `fax`, `email`, `fascia`, `capoluogo`, `simbolo`, `stemma`, `id_cons`, `cap`) VALUES
(58047, 'Guidonia', '', '', '', '', 5, '0', '', '', 0, '');

CREATE TABLE `soraldo_ele_comu_collegi` (
  `id_collegio` int(11) NOT NULL DEFAULT 0,
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_comune` int(11) NOT NULL DEFAULT 0,
  `id_cons_gen` int(11) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_conf` (
  `id_conf` int(11) NOT NULL,
  `descrizione` varchar(50) NOT NULL,
  `limite` int(2) NOT NULL,
  `consin` enum('0','1') NOT NULL DEFAULT '1',
  `infpremio` int(3) NOT NULL,
  `supsbarramento` int(3) NOT NULL,
  `suppremio` int(3) NOT NULL,
  `listinfsbar` int(3) NOT NULL DEFAULT 1,
  `listinfconta` enum('0','1') NOT NULL DEFAULT '1',
  `listsupconta` enum('0','1') NOT NULL DEFAULT '1',
  `supminpremio` int(3) NOT NULL,
  `infminpremio` int(3) NOT NULL,
  `infdisgiunto` enum('0','1') NOT NULL DEFAULT '0',
  `supdisgiunto` enum('0','1') NOT NULL DEFAULT '0',
  `votolista` enum('0','1') NOT NULL DEFAULT '0',
  `inffisso` enum('0','1') NOT NULL DEFAULT '0',
  `supfisso` enum('0','1') NOT NULL DEFAULT '0',
  `fascia_capoluogo` int(2) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_ele_conf` (`id_conf`, `descrizione`, `limite`, `consin`, `infpremio`, `supsbarramento`, `suppremio`, `listinfsbar`, `listinfconta`, `listsupconta`, `supminpremio`, `infminpremio`, `infdisgiunto`, `supdisgiunto`, `votolista`, `inffisso`, `supfisso`, `fascia_capoluogo`) VALUES
(1, 'Legge Italiana 267/2000', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 6),
(2, 'Regione Sicilia precedente al 2008', 2, '0', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 6),
(3, 'Regione Sicilia Legge n. 22 del 16/12/2008', 2, '0', 67, 5, 60, 3, '1', '0', 40, 40, '0', '0', '0', '0', '0', 7),
(4, 'Regione Sicilia Legge n.6/2011', 5, '1', 67, 5, 60, 5, '1', '1', 40, 40, '1', '1', '0', '1', '0', 7),
(5, 'Legge Italiana 267/2000 con riduzione 2011', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 7),
(6, 'Legge Italiana 267/2000 con riduzione 2012', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 7),
(7, 'Legge Italiana 267/2000 con modifiche 2014', 3, '1', 67, 3, 60, 3, '1', '1', 40, 40, '0', '0', '0', '0', '0', 6);

CREATE TABLE `soraldo_ele_consultazione` (
  `id_cons_gen` int(11) NOT NULL,
  `descrizione` text DEFAULT NULL,
  `data_inizio` date DEFAULT NULL,
  `data_fine` date DEFAULT NULL,
  `tipo_cons` int(7) NOT NULL DEFAULT 0,
  `link_trasparenza` varchar(255) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_cons_comune` (
  `id_cons` int(11) NOT NULL,
  `chiusa` set('0','1','2') NOT NULL DEFAULT '0',
  `id_comune` int(11) NOT NULL DEFAULT 0,
  `id_cons_gen` int(11) NOT NULL DEFAULT 0,
  `id_conf` int(11) NOT NULL DEFAULT 0,
  `preferita` enum('0','1') NOT NULL DEFAULT '0',
  `preferenze` tinyint(1) NOT NULL DEFAULT 1,
  `id_fascia` int(2) NOT NULL DEFAULT 1,
  `vismf` enum('0','1') NOT NULL DEFAULT '0',
  `solo_gruppo` enum('0','1') DEFAULT '0',
  `disgiunto` enum('0','1') NOT NULL DEFAULT '0',
  `proiezione` ENUM('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_controlli` (
  `id_cons` int(11) NOT NULL,
  `id_sez` int(11) NOT NULL,
  `tipo` varchar(10) NOT NULL,
  `id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_documenti` (
  `id_doc` int(11) NOT NULL,
  `descrizione` varchar(50) NOT NULL DEFAULT '',
  `nomedoc` varchar(25) NOT NULL DEFAULT '',
  `filedoc` blob NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_fasce` (
  `id_fascia` int(2) NOT NULL,
  `abitanti` int(11) NOT NULL,
  `seggi` int(4) NOT NULL,
  `id_conf` int(11) DEFAULT 1
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_ele_fasce` (`id_fascia`, `abitanti`, `seggi`, `id_conf`) VALUES
(1, 3000, 12, 1),
(2, 10000, 16, 1),
(3, 15000, 20, 1),
(4, 30000, 20, 1),
(5, 100000, 30, 1),
(6, 250000, 40, 1),
(7, 500000, 46, 1),
(8, 1000000, 50, 1),
(9, 100000000, 60, 1),
(1, 3000, 12, 2),
(2, 10000, 16, 2),
(3, 15000, 20, 2),
(4, 30000, 20, 2),
(5, 100000, 30, 2),
(6, 250000, 40, 2),
(7, 500000, 46, 2),
(8, 1000000, 50, 2),
(9, 100000000, 60, 2),
(1, 3000, 9, 3),
(2, 5000, 9, 3),
(4, 15000, 16, 3),
(3, 10000, 12, 3),
(5, 30000, 16, 3),
(6, 100000, 24, 3),
(7, 250000, 32, 3),
(8, 500000, 36, 3),
(9, 1000000, 40, 3),
(10, 100000000, 48, 3),
(1, 3000, 6, 4),
(2, 5000, 7, 4),
(3, 10000, 12, 4),
(4, 15000, 16, 4),
(5, 30000, 16, 4),
(6, 100000, 24, 4),
(7, 250000, 32, 4),
(8, 500000, 36, 4),
(9, 1000000, 40, 4),
(10, 100000000, 48, 4),
(1, 3000, 9, 5),
(2, 5000, 9, 5),
(3, 10000, 12, 5),
(4, 15000, 16, 5),
(5, 30000, 16, 5),
(6, 100000, 24, 5),
(7, 250000, 32, 5),
(8, 500000, 36, 5),
(9, 1000000, 40, 5),
(10, 100000000, 48, 5),
(1, 3000, 6, 6),
(2, 5000, 7, 6),
(3, 10000, 10, 6),
(4, 15000, 16, 6),
(5, 30000, 16, 6),
(6, 100000, 24, 6),
(7, 250000, 32, 6),
(8, 500000, 36, 6),
(9, 1000000, 40, 6),
(10, 100000000, 48, 6),
(1, 3000, 10, 7),
(2, 10000, 12, 7),
(3, 15000, 16, 7),
(4, 30000, 16, 7),
(5, 100000, 24, 7),
(6, 250000, 32, 7),
(7, 500000, 36, 7),
(8, 1000000, 40, 7),
(9, 100000000, 48, 7);

CREATE TABLE `soraldo_ele_gruppo` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_gruppo` int(11) NOT NULL,
  `num_gruppo` int(7) NOT NULL DEFAULT 0,
  `descrizione` mediumtext DEFAULT NULL,
  `simbolo` mediumtext DEFAULT NULL,
  `stemma` blob DEFAULT NULL,
  `id_circ` int(11) NOT NULL DEFAULT 0,
  `num_circ` int(2) UNSIGNED NOT NULL DEFAULT 1,
  `prognome` mediumtext DEFAULT NULL,
  `programma` mediumblob DEFAULT NULL,
  `cv` varchar(255) DEFAULT NULL,
  `cg` varchar(255) DEFAULT NULL,
  `eletto` tinyint(1) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_link` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `mid` int(7) NOT NULL,
  `title` varchar(150) NOT NULL DEFAULT ' ',
  `preamble` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `editimage` varchar(100) NOT NULL DEFAULT ' '
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_lista` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_lista` int(11) NOT NULL,
  `num_lista` int(7) NOT NULL DEFAULT 0,
  `id_gruppo` int(11) NOT NULL DEFAULT 0,
  `num_gruppo` int(2) UNSIGNED NOT NULL DEFAULT 0,
  `id_circ` int(11) NOT NULL DEFAULT 0,
  `num_circ` int(2) UNSIGNED NOT NULL DEFAULT 1,
  `descrizione` text DEFAULT NULL,
  `simbolo` mediumtext DEFAULT NULL,
  `stemma` blob DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_log` (
  `id_cons` int(11) DEFAULT NULL,
  `id_sez` int(11) DEFAULT NULL,
  `utente` varchar(20) DEFAULT NULL,
  `data` date DEFAULT NULL,
  `ora` time DEFAULT NULL,
  `log_da` mediumtext DEFAULT NULL,
  `log_a` mediumtext DEFAULT NULL,
  `tabella` varchar(30) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_modelli` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `categoria` varchar(20) NOT NULL DEFAULT '',
  `modello` blob NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_numeri` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `mid` int(7) NOT NULL,
  `title` varchar(150) NOT NULL DEFAULT '',
  `preamble` mediumtext NOT NULL,
  `content` mediumtext NOT NULL,
  `editimage` varchar(100) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_operatori` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_sede` int(11) NOT NULL DEFAULT 0,
  `id_comune` int(11) NOT NULL DEFAULT 0,
  `permessi` int(3) DEFAULT NULL,
  `aid` varchar(25) NOT NULL DEFAULT '',
  `id_circ` int(11) NOT NULL DEFAULT 0,
  `id_sez` int(11) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_province` (
  `id` tinyint(11) NOT NULL DEFAULT 0,
  `descrizione` varchar(30) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_regioni` (
  `id` int(11) NOT NULL DEFAULT 0,
  `descrizione` varchar(25) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_rilaff` (
  `id_cons_gen` int(11) NOT NULL DEFAULT 0,
  `orario` time NOT NULL DEFAULT '00:00:00',
  `data` date NOT NULL DEFAULT '1900-01-01'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_sede` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_sede` int(11) NOT NULL,
  `id_circ` int(11) NOT NULL DEFAULT 0,
  `indirizzo` varchar(60) DEFAULT NULL,
  `telefono1` varchar(12) DEFAULT NULL,
  `telefono2` varchar(12) DEFAULT NULL,
  `fax` varchar(12) DEFAULT NULL,
  `responsabile` varchar(60) DEFAULT NULL,
  `mappa` mediumblob NOT NULL,
  `filemappa` varchar(100) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_servizi` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `mid` int(7) NOT NULL,
  `title` varchar(150) NOT NULL DEFAULT ' ',
  `preamble` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `editimage` varchar(100) NOT NULL DEFAULT ' '
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_sezioni` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_sez` int(11) NOT NULL,
  `id_sede` int(11) NOT NULL DEFAULT 0,
  `num_sez` int(7) NOT NULL DEFAULT 0,
  `maschi` int(4) DEFAULT NULL,
  `femmine` int(4) DEFAULT NULL,
  `validi` int(7) NOT NULL DEFAULT 0,
  `nulli` int(7) NOT NULL DEFAULT 0,
  `bianchi` int(7) NOT NULL DEFAULT 0,
  `contestati` int(7) NOT NULL DEFAULT 0,
  `solo_gruppo` int(7) NOT NULL DEFAULT 0,
  `autorizzati_m` int(4) NOT NULL DEFAULT 0,
  `autorizzati_f` int(4) NOT NULL DEFAULT 0,
  `voti_nulli` int(7) NOT NULL DEFAULT 0,
  `validi_lista` int(7) NOT NULL DEFAULT 0,
  `contestati_lista` int(7) NOT NULL DEFAULT 0,
  `voti_nulli_lista` int(7) NOT NULL DEFAULT 0,
  `solo_lista` int(7) NOT NULL DEFAULT 0,
  `colore` varchar(50) DEFAULT '#FAFAD2'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_temi` (
  `id` int(11) NOT NULL,
  `tema` varchar(20) NOT NULL DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_tipo` (
  `tipo_cons` int(11) NOT NULL DEFAULT 0,
  `descrizione` varchar(30) DEFAULT NULL,
  `lingua` varchar(2) NOT NULL DEFAULT '0',
  `genere` tinyint(4) NOT NULL DEFAULT 0,
  `voto_g` enum('0','1') NOT NULL DEFAULT '0',
  `voto_l` enum('0','1') NOT NULL DEFAULT '0',
  `voto_c` enum('0','1') NOT NULL DEFAULT '0',
  `circo` enum('0','1') NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_ele_tipo` (`tipo_cons`, `descrizione`, `lingua`, `genere`, `voto_g`, `voto_l`, `voto_c`, `circo`) VALUES
(1, 'PROVINCIALI', 'it', 3, '0', '0', '0', '0'),
(2, 'REFERENDUM', 'it', 0, '0', '0', '0', '0'),
(3, 'COMUNALI', 'it', 5, '0', '0', '0', '0'),
(4, 'CIRCOSCRIZIONALI', 'it', 5, '0', '0', '0', '1'),
(5, 'BALLOTTAGGIO COMUNALI', 'it', 1, '0', '0', '0', '0'),
(6, 'CAMERA', 'it', 2, '0', '0', '0', '0'),
(7, 'SENATO', 'it', 2, '0', '0', '0', '0'),
(8, 'EUROPEE', 'it', 4, '0', '0', '0', '0'),
(9, 'REGIONALI', 'it', 5, '0', '0', '0', '0'),
(10, 'SENATO CON GRUPPI', 'it', 5, '1', '0', '1', '0'),
(11, 'CAMERA CON GRUPPI', 'it', 5, '1', '0', '1', '0'),
(12, 'PROVINCIALI CON COLLEGI', 'it', 3, '0', '0', '0', '1'),
(13, 'BALLOTTAGGIO PROVINCIALI', 'it', 1, '0', '0', '0', '0'),
(14, 'EUROPEE CON COLLEGI', 'it', 4, '0', '0', '0', '1'),
(15, 'CAMERA CON GRUPPI E COLLEGI', 'it', 5, '1', '0', '1', '1'),
(16, 'SENATO CON GRUPPI E COLLEGI', 'it', 5, '1', '0', '1', '1'),
(17, 'REGIONALI CON COLLEGI', 'it', 5, '0', '0', '0', '1'),
(18, 'CAMERA - Rosatellum 2.0', 'it', 5, '0', '0', '1', '0'),
(19, 'SENATO - Rosatellum 2.0', 'it', 5, '0', '0', '1', '0');

CREATE TABLE `soraldo_ele_voti_candidati` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_cand` int(11) NOT NULL DEFAULT 0,
  `id_sez` int(11) NOT NULL DEFAULT 0,
  `num_cand` int(2) UNSIGNED NOT NULL,
  `voti` int(7) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_voti_gruppo` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_gruppo` int(11) NOT NULL DEFAULT 0,
  `id_sez` int(11) NOT NULL DEFAULT 0,
  `num_gruppo` int(2) UNSIGNED NOT NULL,
  `voti` int(7) NOT NULL DEFAULT 0,
  `solo_gruppo` int(7) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_voti_lista` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_lista` int(11) NOT NULL DEFAULT 0,
  `id_sez` int(11) NOT NULL DEFAULT 0,
  `num_lista` int(2) UNSIGNED DEFAULT 0,
  `voti` int(7) NOT NULL DEFAULT 0,
  `nulli_lista` int(7) NOT NULL DEFAULT 0,
  `solo_lista` int(7) DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_voti_parziale` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_sez` int(11) NOT NULL DEFAULT 0,
  `id_parz` int(11) NOT NULL,
  `orario` time NOT NULL DEFAULT '00:00:00',
  `data` date NOT NULL DEFAULT '1900-01-01',
  `voti_uomini` int(7) NOT NULL DEFAULT 0,
  `voti_donne` int(7) NOT NULL DEFAULT 0,
  `voti_complessivi` int(7) NOT NULL DEFAULT 0,
  `id_gruppo` int(11) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_voti_ref` (
  `id_cons` int(11) NOT NULL DEFAULT 0,
  `id_gruppo` int(11) NOT NULL DEFAULT 0,
  `id_sez` int(11) NOT NULL DEFAULT 0,
  `num_gruppo` int(2) UNSIGNED NOT NULL,
  `si` int(7) DEFAULT 0,
  `no` int(7) DEFAULT 0,
  `validi` int(7) DEFAULT 0,
  `nulli` int(7) DEFAULT 0,
  `bianchi` int(7) DEFAULT 0,
  `contestati` int(7) DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `soraldo_ele_widget` (
  `id` int(10) NOT NULL,
  `nome_file` varchar(255) NOT NULL DEFAULT '',
  `titolo` varchar(255) NOT NULL DEFAULT '',
  `pos_or` int(1) NOT NULL DEFAULT 1,
  `pos_ver` int(3) NOT NULL DEFAULT 0,
  `attivo` int(1) NOT NULL DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `soraldo_ele_widget` (`id`, `nome_file`, `titolo`, `pos_or`, `pos_ver`, `attivo`) VALUES
(1, '00_affluenze.php', '00_affluenze.php', 1, 0, 0),
(2, '01_votanti.php', '01_votanti.php', 1, 0, 0),
(3, '02_risultati.php', '02_risultati.php', 1, 0, 0),
(4, '04_sezioni.php', '04_sezioni.php', 1, 0, 0),
(5, 'privacy.php', 'privacy.php', 1, 0, 0),
(6, 'bloccocand.php', 'bloccocand.php', 1, 0, 0),
(7, 'bloccogen.php', 'bloccogen.php', 1, 0, 0),
(8, 'bloccolink.php', 'bloccolink.php', 1, 0, 0),
(9, 'bloccoref.php', 'bloccoref.php', 1, 0, 0),
(10, 'gom_affluenze.php', 'gom_affluenze.php', 1, 0, 0),
(11, 'pie_affluenze.php', 'pie_affluenze.php', 1, 0, 0),
(12, 'social.php', 'social.php', 1, 0, 0),
(13, 'cerca_candidato.php', 'cerca_candidato.php', 1, 0, 0);


ALTER TABLE `soraldo_access`
  ADD PRIMARY KEY (`access_id`);

ALTER TABLE `soraldo_authors`
  ADD PRIMARY KEY (`aid`,`id_comune`),
  ADD KEY `aid` (`aid`);

ALTER TABLE `soraldo_doc_cons`
  ADD KEY `id_cons` (`id_cons`,`id_doc`);

ALTER TABLE `soraldo_ele_candidati`
  ADD PRIMARY KEY (`id_cand`) USING BTREE,
  ADD KEY `id_lista` (`id_lista`),
  ADD KEY `id_cons` (`id_cons`,`id_lista`) USING BTREE;

ALTER TABLE `soraldo_ele_circoscrizione`
  ADD UNIQUE KEY `id_circ` (`id_circ`),
  ADD UNIQUE KEY `id_cons` (`id_cons`,`num_circ`);

ALTER TABLE `soraldo_ele_collegi`
  ADD PRIMARY KEY (`id_collegio`),
  ADD KEY `id_cons_gen` (`id_cons_gen`);

ALTER TABLE `soraldo_ele_come`
  ADD UNIQUE KEY `mid` (`mid`);

ALTER TABLE `soraldo_ele_comuni`
  ADD PRIMARY KEY (`id_comune`),
  ADD KEY `access_id` (`descrizione`);

ALTER TABLE `soraldo_ele_comu_collegi`
  ADD PRIMARY KEY (`id_cons_gen`,`id_comune`),
  ADD KEY `id_cons` (`id_cons`),
  ADD KEY `id_collegio` (`id_collegio`);

ALTER TABLE `soraldo_ele_conf`
  ADD PRIMARY KEY (`id_conf`);

ALTER TABLE `soraldo_ele_consultazione`
  ADD PRIMARY KEY (`id_cons_gen`),
  ADD UNIQUE KEY `descrizione` (`descrizione`(100));

ALTER TABLE `soraldo_ele_cons_comune`
  ADD PRIMARY KEY (`id_cons`),
  ADD UNIQUE KEY `comune` (`id_comune`,`id_cons_gen`);

ALTER TABLE `soraldo_ele_controlli`
  ADD KEY `sezione` (`id_sez`);

ALTER TABLE `soraldo_ele_documenti`
  ADD PRIMARY KEY (`id_doc`),
  ADD KEY `descrizione` (`descrizione`);

ALTER TABLE `soraldo_ele_fasce`
  ADD KEY `id_fascia` (`id_fascia`);

ALTER TABLE `soraldo_ele_gruppo`
  ADD PRIMARY KEY (`id_gruppo`) USING BTREE,
  ADD KEY `id_cons` (`id_cons`,`id_circ`) USING BTREE;

ALTER TABLE `soraldo_ele_link`
  ADD PRIMARY KEY (`mid`);

ALTER TABLE `soraldo_ele_lista`
  ADD PRIMARY KEY (`id_lista`) USING BTREE,
  ADD KEY `id_gruppo` (`id_gruppo`),
  ADD KEY `id_cons` (`id_cons`,`id_gruppo`) USING BTREE;

ALTER TABLE `soraldo_ele_modelli`
  ADD KEY `access_id` (`id_cons`);

ALTER TABLE `soraldo_ele_numeri`
  ADD PRIMARY KEY (`mid`),
  ADD KEY `id_cons` (`id_cons`);

ALTER TABLE `soraldo_ele_operatori`
  ADD UNIQUE KEY `id_cons_aid` (`id_cons`,`aid`,`id_comune`),
  ADD KEY `id_circ` (`id_comune`),
  ADD KEY `id_sede` (`id_sede`);

ALTER TABLE `soraldo_ele_regioni`
  ADD PRIMARY KEY (`id`),
  ADD KEY `descrizione` (`descrizione`);

ALTER TABLE `soraldo_ele_rilaff`
  ADD KEY `id_cons_gen` (`id_cons_gen`);

ALTER TABLE `soraldo_ele_sede`
  ADD PRIMARY KEY (`id_sede`),
  ADD KEY `id_cons` (`id_cons`),
  ADD KEY `id_circ` (`id_circ`);

ALTER TABLE `soraldo_ele_servizi`
  ADD PRIMARY KEY (`mid`),
  ADD KEY `id_cons` (`id_cons`);

ALTER TABLE `soraldo_ele_sezioni`
  ADD UNIQUE KEY `id_sezi` (`id_sez`),
  ADD UNIQUE KEY `id_cons` (`id_cons`,`num_sez`) USING BTREE,
  ADD KEY `id_sede` (`id_sede`);

ALTER TABLE `soraldo_ele_temi`
  ADD PRIMARY KEY (`id`);

ALTER TABLE `soraldo_ele_tipo`
  ADD PRIMARY KEY (`tipo_cons`);

ALTER TABLE `soraldo_ele_voti_candidati`
  ADD KEY `id_sez` (`id_sez`),
  ADD KEY `id_cand` (`id_cand`),
  ADD KEY `id_cons` (`id_cons`,`id_sez`,`id_cand`) USING BTREE;

ALTER TABLE `soraldo_ele_voti_gruppo`
  ADD KEY `id_gruppo` (`id_gruppo`),
  ADD KEY `id_sez` (`id_sez`),
  ADD KEY `id_cons` (`id_cons`,`id_sez`,`id_gruppo`) USING BTREE;

ALTER TABLE `soraldo_ele_voti_lista`
  ADD KEY `id_lista` (`id_lista`),
  ADD KEY `id_sez` (`id_sez`),
  ADD KEY `id_cons` (`id_cons`,`id_sez`,`id_lista`) USING BTREE;

ALTER TABLE `soraldo_ele_voti_parziale`
  ADD PRIMARY KEY (`id_parz`),
  ADD KEY `id_cons` (`id_cons`),
  ADD KEY `id_sez` (`id_sez`),
  ADD KEY `id_gruppo` (`id_gruppo`);

ALTER TABLE `soraldo_ele_voti_ref`
  ADD KEY `id_gruppo` (`id_gruppo`),
  ADD KEY `id_sez` (`id_sez`),
  ADD KEY `id_cons` (`id_cons`,`id_gruppo`) USING BTREE;

ALTER TABLE `soraldo_ele_widget`
  ADD PRIMARY KEY (`id`);


ALTER TABLE `soraldo_ele_candidati`
  MODIFY `id_cand` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_circoscrizione`
  MODIFY `id_circ` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_collegi`
  MODIFY `id_collegio` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_come`
  MODIFY `mid` int(7) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_conf`
  MODIFY `id_conf` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

ALTER TABLE `soraldo_ele_consultazione`
  MODIFY `id_cons_gen` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_cons_comune`
  MODIFY `id_cons` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_documenti`
  MODIFY `id_doc` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_gruppo`
  MODIFY `id_gruppo` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_link`
  MODIFY `mid` int(7) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_lista`
  MODIFY `id_lista` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_numeri`
  MODIFY `mid` int(7) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_sede`
  MODIFY `id_sede` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_servizi`
  MODIFY `mid` int(7) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_sezioni`
  MODIFY `id_sez` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_temi`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_voti_parziale`
  MODIFY `id_parz` int(11) NOT NULL AUTO_INCREMENT;

ALTER TABLE `soraldo_ele_widget`
  MODIFY `id` int(10) NOT NULL AUTO_INCREMENT;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
